/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.soo.dtoc;

import com.ibm.hwmca.fw.soo.dtoc.master;
import java.io.IOException;
import java.io.InputStream;

final class receiv
implements Runnable {
    private final String copyright = "(c) Copyright IBM Corp.  1997, 1998.  All rights reserved.";
    private InputStream is;
    private volatile Thread runner;
    private byte[] buffer = new byte[262144];
    private int head;
    private int tail;
    private boolean fWaitFill;
    private boolean fWaitRoom;
    private byte[] tmpbuf = new byte[4096];
    private int count;
    private int pos;
    private boolean fValid = false;
    private master m;
    private static final String TRACE_MASKT = "XDTCRCVT";
    private static final String TRACE_MASKF = "XDTCRCVF";
    private static final String TRACE_MASKD = "XDTCRCVD";

    public receiv(master m) {
        this.m = m;
    }

    public void initialize(InputStream is) {
        if (this.runner == null) {
            this.is = is;
            this.count = 0;
            this.pos = 0;
            this.tail = 0;
            this.head = 0;
            this.fWaitFill = false;
            this.fWaitRoom = false;
            this.fValid = true;
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void terminate() {
        this.m.trace(2, TRACE_MASKT, "-> terminate");
        if (this.runner != null) {
            this.runner = null;
            this.fValid = false;
            byte[] byArray = this.buffer;
            // MONITORENTER : this.buffer
            this.buffer.notify();
            // MONITOREXIT : byArray
        }
        this.m.trace(2, TRACE_MASKT, "<- terminate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        this.m.trace(2, TRACE_MASKT, "-> run");
        try {
            while (this.runner != null && this.fValid) {
                int maxlen;
                block16: {
                    int index;
                    block15: {
                        byte[] byArray = this.buffer;
                        // MONITORENTER : this.buffer
                        while (true) {
                            if (!this.fValid || (this.tail + 1) % this.buffer.length != this.head) {
                                index = this.head;
                                // MONITOREXIT : byArray
                                if (index > this.tail) break block15;
                                if (index != 0) break;
                                maxlen = this.buffer.length - this.tail - 1;
                                break block16;
                            }
                            this.fWaitRoom = true;
                            this.buffer.wait();
                        }
                        maxlen = this.buffer.length - this.tail;
                        break block16;
                    }
                    maxlen = index - this.tail - 1;
                }
                int len = this.is.read(this.buffer, this.tail, maxlen);
                if (len != -1) {
                    byte[] byArray = this.buffer;
                    // MONITORENTER : this.buffer
                    this.tail = (this.tail + len) % this.buffer.length;
                    if (this.fWaitFill) {
                        this.fWaitFill = false;
                        this.buffer.notify();
                    }
                    // MONITOREXIT : byArray
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            this.m.trace(2, TRACE_MASKF, "IOException in run(): " + e.getMessage());
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.is = null;
        this.fValid = false;
        this.m.trace(2, TRACE_MASKT, "<- run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            try {
                while (this.fValid && this.head == this.tail) {
                    this.fWaitFill = true;
                    this.buffer.wait();
                }
                int maxlen = this.head < this.tail ? (this.tail - this.head > this.tmpbuf.length ? this.tmpbuf.length : this.tail - this.head) : (this.buffer.length - this.head > this.tmpbuf.length ? this.tmpbuf.length : this.buffer.length - this.head);
                System.arraycopy(this.buffer, this.head, this.tmpbuf, 0, maxlen);
                this.head = (this.head + maxlen) % this.buffer.length;
                this.count = maxlen;
                this.pos = 0;
                if (this.fWaitRoom) {
                    this.fWaitRoom = false;
                    this.buffer.notify();
                }
            }
            catch (InterruptedException e) {
                this.fValid = false;
            }
            return;
        }
    }

    public void getShorts(short[] buf, int len) {
        int i = 0;
        while (i < len) {
            buf[i] = (short)(this.getByte() & 0xFF);
            ++i;
        }
    }

    public void getBytes(byte[] buf, int len) {
        int i = 0;
        while (i < len) {
            buf[i] = this.getByte();
            ++i;
        }
    }

    public byte getByte() {
        if (this.count == 0) {
            this.fill();
        }
        byte b = this.tmpbuf[this.pos];
        ++this.pos;
        --this.count;
        return b;
    }

    public boolean isValid() {
        return this.fValid;
    }

    public boolean isAvailable() {
        return this.count != 0 || this.head != this.tail;
    }
}

